//
//  Creating_Custom_Table_View_Cell_AccessoriesViewController.m
//  Creating Custom Table View Cell Accessories
//
//  Created by Vandad Nahavandipoor on 29/07/2011.
//  Copyright 2011 Pixolity Ltd. All rights reserved.
//

#import "Creating_Custom_Table_View_Cell_AccessoriesViewController.h"

@implementation Creating_Custom_Table_View_Cell_AccessoriesViewController

@synthesize myTableView;

- (void) performExpand:(UIButton *)paramSender{
  
  UITableViewCell *ownerCell = (UITableViewCell*)paramSender.superview;
  
  if (ownerCell != nil){
    
    /* Pobranie ścieżki indeksu komórki zawierającej sekcję i rekord komórki. */
    
    NSIndexPath *ownerCellIndexPath = 
      [self.myTableView indexPathForCell:ownerCell];
    
    NSLog(@"Naciśnięto przycisk pomocniczy w komórce o indeksie = %@", 
          ownerCellIndexPath);
    
      /* Wykorzystanie posiadanych wartości do określenia, w której komórce
       przycisk pomocniczy spowodował wygenerowanie zdarzenia:
     
     OwnerCellIndexPath.section
     OwnerCellIndexPath.row
     
     */
    
    if (ownerCellIndexPath.section == 0 &&
        ownerCellIndexPath.row == 1){
      /* To jest drugi rekord w pierwszej sekcji. */
    }
    
    /* Sprawdzenie pozostałych komórek... */
    
  }
  
}

- (UITableViewCell *)tableView:(UITableView *)tableView
         cellForRowAtIndexPath:(NSIndexPath *)indexPath{
  
  UITableViewCell* result = nil;
  
  static NSString *MyCellIdentifier = @"SimpleCell";
  
  /* Próba pobrania istniejącej komórki o podanym identyfikatorze. */
  result = [tableView dequeueReusableCellWithIdentifier:MyCellIdentifier];
  
  if (result == nil){
    result = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleDefault
                                    reuseIdentifier:MyCellIdentifier];
  }
  
  result.textLabel.text = [NSString stringWithFormat:@"Sekcja %ld, komórka %ld",
                           (long)indexPath.section,
                           (long)indexPath.row];
  
  UIButton *button = [UIButton buttonWithType:UIButtonTypeRoundedRect];
  button.frame = CGRectMake(0.0f, 0.0f, 150.0f, 25.0f);
  
  [button setTitle:@"Rozwiń"
          forState:UIControlStateNormal];
  
  [button addTarget:self
             action:@selector(performExpand:)
   forControlEvents:UIControlEventTouchUpInside];
  
  result.accessoryView = button;
  
  return result;
  
}

- (NSInteger) numberOfSectionsInTableView:(UITableView *)tableView{
  return 3;
}

- (NSInteger) tableView:(UITableView *)tableView 
  numberOfRowsInSection:(NSInteger)section{
  return 3;
}

- (void)viewDidLoad{
  [super viewDidLoad];
  
  self.myTableView = [[UITableView alloc] initWithFrame:self.view.bounds
                                                  style:UITableViewStylePlain];
  
  self.myTableView.dataSource = self;
  self.myTableView.delegate = self;
  
  self.myTableView.autoresizingMask = 
  UIViewAutoresizingFlexibleWidth |
  UIViewAutoresizingFlexibleHeight;
  
  [self.view addSubview:self.myTableView];
  
}

- (void)viewDidUnload{
  [super viewDidUnload];
  self.myTableView = nil;
}

- (BOOL)shouldAutorotateToInterfaceOrientation
:(UIInterfaceOrientation)interfaceOrientation{
  return YES;
}

@end
